/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.retained;

import com.sun.j3d.utils.scenegraph.io.UnsupportedUniverseException;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SGIORuntimeException;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTable;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.BranchGroupState;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SceneGraphObjectState;
import com.sun.j3d.utils.universe.ConfiguredUniverse;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ListIterator;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CapabilityNotSetException;

public class RandomAccessFileControl
extends Controller {
    protected String FILE_IDENT = new String("j3dff");
    private long user_data;
    private long universe_config;
    private long symbol_table;
    private RandomAccessFile raf;
    private int branchGraphCount = 0;
    private boolean writeMode = false;
    private Object userData;

    public RandomAccessFileControl() {
        this.symbolTable = new SymbolTable(this);
    }

    public void createFile(File file, SimpleUniverse simpleUniverse, boolean bl, String string, Serializable serializable) throws IOException, UnsupportedUniverseException, CapabilityNotSetException {
        this.raf = new RandomAccessFile(file, "rw");
        this.writeMode = true;
        this.raf.seek(0L);
        this.raf.writeUTF(this.FILE_IDENT);
        this.raf.seek(20L);
        this.raf.writeInt(this.outputFileVersion);
        this.raf.seek(68L);
        this.raf.writeInt(0);
        this.raf.seek(72L);
        if (string == null) {
            string = "";
        }
        this.raf.writeUTF(string);
        try {
            this.writeSerializedData(this.raf, serializable);
            this.universe_config = this.raf.getFilePointer();
            this.writeUniverse(this.raf, simpleUniverse, bl);
        }
        catch (SGIORuntimeException sGIORuntimeException) {
            throw new IOException(sGIORuntimeException.getMessage());
        }
    }

    public void openFile(File file) throws IOException {
        this.raf = new RandomAccessFile(file, "r");
        this.writeMode = false;
        this.raf.seek(0L);
        String string = this.raf.readUTF();
        if (string.equals("demo_j3f")) {
            throw new IOException("Use Java 3D Fly Through I/O instead of Java 3D Scenegraph I/O");
        }
        if (!string.equals("j3dff")) {
            throw new IOException("This is a Stream - use SceneGraphStreamReader instead");
        }
        this.raf.seek(20L);
        this.currentFileVersion = this.raf.readInt();
        if (this.currentFileVersion > this.outputFileVersion) {
            throw new IOException("Unsupported file version. This file was written using a new version of the SceneGraph IO API, please update your installtion to the latest version");
        }
        String string2 = this.readFileDescription();
        this.raf.seek(68L);
        this.branchGraphCount = this.raf.readInt();
        this.raf.seek(60L);
        this.universe_config = this.raf.readLong();
        this.raf.seek(30L);
        this.symbol_table = this.raf.readLong();
        this.raf.seek(this.symbol_table);
        this.symbolTable.readTable(this.raf, false);
        this.raf.seek(this.user_data);
        this.userData = this.readSerializedData(this.raf);
    }

    public ConfiguredUniverse readUniverse(boolean bl, Canvas3D canvas3D) throws IOException {
        this.raf.seek(this.universe_config);
        return this.readUniverse(this.raf, bl, canvas3D);
    }

    public Object getUserData() {
        return this.userData;
    }

    protected void readBranchGraphs(int[] nArray) throws IOException {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.readBranchGraph(nArray[i2]);
        }
    }

    public int getBranchGraphCount() {
        return this.symbolTable.getBranchGraphCount();
    }

    public void writeBranchGraph(BranchGroup branchGroup, Serializable serializable) throws IOException {
        long l2 = this.raf.getFilePointer();
        this.raf.writeInt(0);
        try {
            this.writeSerializedData(this.raf, serializable);
            SymbolTableData symbolTableData = this.symbolTable.getSymbol(branchGroup);
            if (symbolTableData == null) {
                symbolTableData = this.symbolTable.createSymbol(branchGroup);
                symbolTableData.branchGraphID = -1;
            }
            this.symbolTable.setBranchGraphRoot(symbolTableData, l2);
            this.symbolTable.startUnsavedNodeComponentFrame();
            SceneGraphObjectState sceneGraphObjectState = this.createState(branchGroup, symbolTableData);
            try {
                this.writeObject(this.raf, sceneGraphObjectState);
                this.writeNodeComponents(this.raf);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.symbolTable.endUnsavedNodeComponentFrame();
        }
        catch (SGIORuntimeException sGIORuntimeException) {
            throw new IOException(sGIORuntimeException.getMessage());
        }
    }

    public BranchGroup[] readBranchGraph(int n2) throws IOException {
        try {
            int n3;
            int[] nArray = this.symbolTable.getBranchGraphDependencies(n2);
            BranchGroupState[] branchGroupStateArray = new BranchGroupState[nArray.length + 1];
            BranchGroup[] branchGroupArray = new BranchGroup[branchGroupStateArray.length];
            branchGroupStateArray[0] = this.readSingleBranchGraph(n2);
            for (n3 = 0; n3 < nArray.length; ++n3) {
                branchGroupStateArray[n3 + 1] = this.readSingleBranchGraph(nArray[n3]);
            }
            for (n3 = 0; n3 < branchGroupStateArray.length; ++n3) {
                if (!branchGroupStateArray[n3].getSymbol().graphBuilt) {
                    branchGroupStateArray[n3].buildGraph();
                    branchGroupStateArray[n3].getSymbol().graphBuilt = true;
                }
                branchGroupArray[n3] = (BranchGroup)branchGroupStateArray[n3].getNode();
            }
            this.symbolTable.clearUnshared();
            return branchGroupArray;
        }
        catch (SGIORuntimeException sGIORuntimeException) {
            throw new IOException(sGIORuntimeException.getMessage());
        }
    }

    public BranchGroup[] readAllBranchGraphs() throws IOException {
        int n2 = this.getBranchGraphCount();
        BranchGroupState[] branchGroupStateArray = new BranchGroupState[n2];
        BranchGroup[] branchGroupArray = new BranchGroup[n2];
        try {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                branchGroupStateArray[n3] = this.readSingleBranchGraph(n3);
            }
            for (n3 = 0; n3 < branchGroupStateArray.length; ++n3) {
                if (!branchGroupStateArray[n3].getSymbol().graphBuilt) {
                    branchGroupStateArray[n3].buildGraph();
                    branchGroupStateArray[n3].getSymbol().graphBuilt = true;
                }
                branchGroupArray[n3] = (BranchGroup)branchGroupStateArray[n3].getNode();
            }
            this.symbolTable.clearUnshared();
        }
        catch (SGIORuntimeException sGIORuntimeException) {
            throw new IOException(sGIORuntimeException.getMessage());
        }
        return branchGroupArray;
    }

    private BranchGroupState readSingleBranchGraph(int n2) throws IOException {
        SymbolTableData symbolTableData = this.symbolTable.getBranchGraphRoot(n2);
        if (symbolTableData.nodeState != null) {
            return (BranchGroupState)symbolTableData.nodeState;
        }
        this.raf.seek(this.symbolTable.getBranchGraphFilePosition(n2));
        return this.readNextBranchGraph();
    }

    private BranchGroupState readNextBranchGraph() throws IOException {
        int n2 = this.raf.readInt();
        this.skipUserData(this.raf);
        BranchGroupState branchGroupState = null;
        try {
            branchGroupState = (BranchGroupState)this.readObject(this.raf);
            this.readNodeComponents(this.raf);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return branchGroupState;
    }

    public Object readBranchGraphUserData(int n2) throws IOException {
        try {
            this.raf.seek(this.symbolTable.getBranchGraphFilePosition(n2));
            int n3 = this.raf.readInt();
            return this.readSerializedData(this.raf);
        }
        catch (SGIORuntimeException sGIORuntimeException) {
            throw new IOException(sGIORuntimeException.getMessage());
        }
    }

    protected void writeNodeComponents(DataOutput dataOutput) throws IOException {
        long l2 = 0L;
        ListIterator listIterator = this.symbolTable.getUnsavedNodeComponents();
        dataOutput.writeInt(this.symbolTable.getUnsavedNodeComponentsSize());
        while (listIterator.hasNext()) {
            SymbolTableData symbolTableData = (SymbolTableData)listIterator.next();
            dataOutput.writeInt(symbolTableData.nodeID);
            l2 = this.raf.getFilePointer();
            dataOutput.writeLong(0L);
            this.writeObject(dataOutput, symbolTableData.getNodeState());
            long l3 = this.raf.getFilePointer();
            this.raf.seek(l2);
            dataOutput.writeLong(l3);
            this.raf.seek(l3);
        }
    }

    protected void readNodeComponents(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = dataInput.readInt();
            long l2 = dataInput.readLong();
            if (this.symbolTable.isLoaded(n3)) {
                this.raf.seek(l2);
                continue;
            }
            SceneGraphObjectState sceneGraphObjectState = this.readObject(dataInput);
        }
    }

    public void writeObject(DataOutput dataOutput, SceneGraphObjectState sceneGraphObjectState) throws IOException {
        this.symbolTable.setFilePosition(this.raf.getFilePointer(), sceneGraphObjectState);
        try {
            super.writeObject(dataOutput, sceneGraphObjectState);
        }
        catch (SGIORuntimeException sGIORuntimeException) {
            throw new IOException(sGIORuntimeException.getMessage());
        }
    }

    public String readFileDescription() throws IOException {
        this.raf.seek(72L);
        String string = this.raf.readUTF();
        this.user_data = this.raf.getFilePointer();
        return string;
    }

    public void loadNodeComponent(SymbolTableData symbolTableData) throws IOException {
        try {
            this.raf.seek(symbolTableData.filePosition);
            this.readObject(this.raf);
        }
        catch (SGIORuntimeException sGIORuntimeException) {
            throw new IOException(sGIORuntimeException.getMessage());
        }
    }

    public void loadSharedGroup(SymbolTableData symbolTableData) throws IOException {
        try {
            this.raf.seek(symbolTableData.filePosition);
            this.readObject(this.raf);
        }
        catch (SGIORuntimeException sGIORuntimeException) {
            throw new IOException(sGIORuntimeException.getMessage());
        }
    }

    public void close() throws IOException {
        try {
            if (this.writeMode) {
                this.writeClose();
            }
            this.raf.close();
            super.reset();
        }
        catch (SGIORuntimeException sGIORuntimeException) {
            throw new IOException(sGIORuntimeException.getMessage());
        }
    }

    private void writeClose() throws IOException {
        this.symbol_table = this.raf.getFilePointer();
        super.getSymbolTable().writeTable(this.raf);
        this.raf.seek(60L);
        this.raf.writeLong(this.universe_config);
        this.raf.seek(30L);
        this.raf.writeLong(this.symbol_table);
        this.raf.seek(68L);
        this.raf.writeInt(this.symbolTable.getBranchGraphCount());
    }

    public long getFilePointer() {
        try {
            return this.raf.getFilePointer();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public int getBranchGraphPosition(BranchGroup branchGroup) {
        SymbolTableData symbolTableData = this.symbolTable.getSymbol(branchGroup);
        if (symbolTableData != null) {
            return symbolTableData.branchGraphID;
        }
        return -1;
    }
}

